function LE=life_exp4(MR,uptoage)
% return the life expectancy associated with a mortality rate vector
% input: X is ln per 100 mortality rate

    surv=survivalcurve(MR);
    
    surv=surv(1:uptoage);            % censor at this age
    MR=MR(1:uptoage);
    
    T_MR=length(surv);
    age=1:T_MR;
    age=age-0.5*ones(1,T_MR);       % o/w bias as people die during the year
    
    LE=age*(surv.*exp(MR))/100 + (surv(T_MR)*(T_MR+1))/100;     % censor after max observed age
    
end